
package com.RT_Printer;

import com.RT_Printer.util.Utils;
import com.RT_Printer.WIFI.WifiPrintDriver;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;

// the App main Activity,start from here
//@author:
//@email:
//@date:2013-03-05

public class RTPrinterActivity extends Activity {
    /** Called when the activity is first created. */
//	private Button mBtnConnetBluetoothDevice = null;
	private Button mBtnConnetWifiDevice = null;
	private Button mBtnQuit = null;
	private Button mBtnPrint = null;
	private Button mBtnPrintOption = null;
	private Button mBtnTest = null;
	private EditText mIPAdrressAndPort = null;
	private EditText mPrintContent = null;
	private CheckBox mBeiKuan = null;
	private CheckBox mUnderline = null;
	private CheckBox mBold = null;
	private CheckBox mBeiGao = null;
	private CheckBox mMinifont = null;
	private CheckBox mHightlight = null;
	public WifiPrintDriver wifiSocket = null;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        setTitle(R.string.bluetooth_unconnected);
        InitUIControl();
    }

	private void InitUIControl(){
    	mBtnQuit = (Button)findViewById(R.id.btn_quit);
    	mBtnQuit.setOnClickListener(mBtnQuitOnClickListener);
    	mBtnConnetWifiDevice = (Button)findViewById(R.id.btn_connect_to_ip);
    	mBtnConnetWifiDevice.setOnClickListener(mBtnConnetWifiDeviceOnClickListener);
    	mBtnPrint = (Button)findViewById(R.id.btn_print);
    	mBtnPrint.setOnClickListener(mBtnPrintOnClickListener);
    	mBtnPrintOption = (Button)findViewById(R.id.btn_option);
    	mBtnPrintOption.setOnClickListener(mBtnPrintOptionOnClickListener);
    	mBtnTest = (Button)findViewById(R.id.btn_test);
    	mBtnTest.setOnClickListener(mBtnTestOnClickListener);
    	mIPAdrressAndPort = (EditText)findViewById(R.id.edt_ip_address);
    	mPrintContent = (EditText)findViewById(R.id.edt_print_content);
    	mBeiKuan = (CheckBox)findViewById(R.id.checkbox_beikuan);
    	mUnderline = (CheckBox)findViewById(R.id.checkbox_underline);
    	mBold = (CheckBox)findViewById(R.id.checkbox_bold);
    	mBeiGao = (CheckBox)findViewById(R.id.checkbox_beigao);
    	mMinifont = (CheckBox)findViewById(R.id.checkbox_minifont);
    	mHightlight = (CheckBox)findViewById(R.id.checkbox_hightlight);
    }



    @Override
	protected void onResume() {
		super.onResume();
	}



	@Override
	protected void onDestroy() {
		WifiPrintDriver.Close();
		super.onDestroy();
	}


	OnClickListener mBtnQuitOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			WifiPrintDriver.Close();
			finish();
		}
	};



	OnClickListener mBtnConnetWifiDeviceOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			String tmpStr = mIPAdrressAndPort.getText().toString();
			String ipAddress = "";
			String tmpPort = "";
			int port = 9100;
			String[] strings = Utils.StringSplit(tmpStr, ":");
			ipAddress = strings[0];
			tmpPort = strings[1];
			port = Integer.parseInt(tmpPort);

			
			// WIFI
        	if(!WifiPrintDriver.WIFISocket(ipAddress, port)) 
        	{
        		WifiPrintDriver.Close();
        		RTPrinterActivity.this.setTitle(R.string.wifi_connect_fail);
        	}
        	else
        	{
        		RTPrinterActivity.this.setTitle(R.string.wifi_connect_sucess);
        	}
        	
		}
	};

	OnClickListener mBtnPrintOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			WifiPrintDriver.Begin();
			if(mBeiKuan.isChecked()){
				WifiPrintDriver.SetZoom((byte)0x10);
			}
			if(mBeiGao.isChecked()){
				WifiPrintDriver.SetZoom((byte)0x01);
			}
			if(mUnderline.isChecked()){
				WifiPrintDriver.SetUnderline((byte)0x02);//»
			}
			if(mBold.isChecked()){
				WifiPrintDriver.AddBold((byte)0x01);//
			}
			if(mMinifont.isChecked()){
				WifiPrintDriver.SetCharacterFont((byte)0x01);
			}
			if(mHightlight.isChecked()){
				WifiPrintDriver.AddInverse((byte)0x01);
			}
			String tmpContent = mPrintContent.getText().toString();
			WifiPrintDriver.ImportData(tmpContent);
			WifiPrintDriver.ImportData("\r");
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
		}
	};

	OnClickListener mBtnPrintOptionOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			Intent intent = new Intent();
			intent.setClass(RTPrinterActivity.this, PrinterOptionActivity.class);
			//intent.putExtra("mBloothPrinter", mBloothPrinter);
			startActivity(intent);
		}
	};
	OnClickListener mBtnTestOnClickListener = new OnClickListener() {
		@Override
		public void onClick(View v) {
			if(WifiPrintDriver.IsNoConnection()){
				return;
			}
			WifiPrintDriver.Begin();
			//String tmpContent = mPrintContent.getText().toString();
			//mBloothPrinter.ImportData(tmpContent);
			WifiPrintDriver.ImportData(new byte[]{0x12,0x54},2);	//ӡԲҳ
			WifiPrintDriver.excute();
			WifiPrintDriver.ClearData();
		}
	};
}